# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#WhineCube BS2 LLE - by Masken

#.base 0x81300000

.macro	la
	lis	\1,\2@h
	ori	\1,\1,\2@l
.endm

#The apploader wants to call OSReport. We need to provide it.
OSReport:
.long	0x08000004	#emulator's osreport function
	blr

Prolog:
.long	0
Main:
.long	0
Epilog:
.long	0

Address:
.long	0
Size:
.long	0
Offset:
.long	0

start:
	#Set parameters for apploader entrypoint
	li r3, 0x81300000
	ori r4, r3, 0x0C
	ori r5, r3, 0x10
	ori r3, r3, 0x08
	li r1, 0x8130FFFC	#Stack pointer

	#Execute entrypoint
	mtctr r0	#r0 is loaded with the apploader entrypoint by the emulator
	bctrl

	#Execute prolog
	li r3, 0x81300000
	lwz r0, 0x08(r3)
	mtctr r0
	bctrl

	#Execute main
MainLoop:
	li r3, 0x81300000
	lwz r0, 0x0C(r3)
	ori r4, r3, 0x18
	ori r5, r3, 0x1C
	ori r3, r3, 0x14
	mtctr r0
	bctrl

	li r7, 0x81300000
	lwz r4, 0x18(r7)
	cmpi cr0, r4, 0
	beq cr0, ReadDone

ReadBegin:
	lwz r5, 0x1C(r7)
	rlwinm r5, r5, 30, 2, 31	#shr 2
	lwz r7, 0x14(r7)

	li r8, 0xCC000000
	li r6, 0xA8000000
	li r9, 0
	stw r9, 0x6000(r8)	#disable interrupts
	stw r6, 0x6008(r8)	#command
	stw r5, 0x600C(r8)	#offset
	stw r4, 0x6010(r8)	#src length
	stw r7, 0x6014(r8)	#dest address
	stw r4, 0x6018(r8)	#dest length
	li r6, 0x0003
	stw r6, 0x601C(r8)	#execute DMA
ReadDone:
	cmpi cr0, r3, 0
	bne cr0, MainLoop

	#Execute epilog
	li r3, 0x81300000
	lwz r0, 0x10(r3)
	mtctr r0
	bctrl

	.long 0x08000002	#Nofity the emulator that the DOL has been loaded

	#DOL entrypoint will now be in r3. Jump there.
	mtctr r3
	bctrl


	#We should never get here
	la r3, ErrorMessage
	.long 0x08000000	#Send error message through the EmuDebug system
iloop:	b iloop

ErrorMessage:
.string "End of the Line! (main returned to WhineCube's bs2)"
